//
//  ItemsChainView.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 10/16/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRDraggableView.h"
#import "CRCollectionViewBaseLayouts.h"

extern NSString* const CRItemsCollectionItemPasteboardType;

//////////////////////////////////////////////////////////////////////
// CRCollectionViewItemBase
//////////////////////////////////////////////////////////////////////
@interface CRCollectionViewItemBase : CRDraggableView
{
}

@property (assign) id controller;

- (NSImage *)imageToDrag;
- (NSPasteboard *)pasteboardToDrag;

@end

//////////////////////////////////////////////////////////////////////
// CRCollectionViewItemIconBased - base view item, contains an icon
// that is automatically highlighted on mouse enter
//////////////////////////////////////////////////////////////////////
@interface CRCollectionViewItemIconBased : CRCollectionViewItemBase
{
}

@property (assign) IBOutlet NSImageView* iconView;

- (void)highlight:(BOOL)bHighlight;
- (NSShadow *)buildHighlightObject;

@end

//////////////////////////////////////////////////////////////////////
// CRItemViewControllerBase
//////////////////////////////////////////////////////////////////////
@interface CRItemViewControllerBase : NSViewController
{
}

- (NSImage *)viewImage;
- (void)setSelected:(BOOL)bSelected;

+ (NSArray *)supportedDragTypes;
+ (NSArray *)objectsWithPasteboard:(NSPasteboard *)pasteboard;

@end

//////////////////////////////////////////////////////////////////////
// CRItemsCollectionItemPlaceholderView
//////////////////////////////////////////////////////////////////////
@interface CRItemsCollectionItemPlaceholderView : NSView
{
}

@end

//////////////////////////////////////////////////////////////////////
// CRItemsCollectionViewSelectionMarker
//////////////////////////////////////////////////////////////////////
@interface CRItemsCollectionViewSelectionMarker : NSView
{
}

@end

//////////////////////////////////////////////////////////////////////
// CRItemsCollectionView
//////////////////////////////////////////////////////////////////////
@interface CRItemsCollectionView : CRControl
{
@private
	BOOL									ignoreContentChanges;	// flag, subj
	BOOL									suspendLayoutChanges;	// flag, subj
	NSView*									placeholderView;		// items placeholder view
	NSColor*								backPattern;			// background patter image
	
@protected
	NSArrayController*	assigned			contentArrayController;
	NSMutableArray*							contentControllers;
	NSMutableArray*							content;
	
	CRCollectionViewLayoutBase*				layout;
	BOOL									wasMouseDown;
	BOOL									selectOnMouseUp;
	BOOL									preserveSelection;		// when the content is re-loaded
	NSImage*								backgroundImage;
	
@protected
	id	assigned							draggSource;
	id	assigned							selectedController;
	NSUInteger								selectedIndex;
	CRItemsCollectionViewSelectionMarker*	selectionMarker;
}

@property (nonatomic, strong) CRCollectionViewLayoutBase*	layout;
@property (nonatomic, assign) BOOL							selectOnMouseUp;
@property (nonatomic, assign) BOOL							suspendLayoutChanges;
@property (nonatomic, assign) BOOL							preserveSelection;
@property (nonatomic, strong) NSArray*						content;
@property (nonatomic, assign) id							selectedObject;
@property (nonatomic, assign) NSUInteger					selectedIndex;
@property (nonatomic, strong) NSImage*						backgroundImage;

- (void)afterItemsReloaded;
- (void)updateLayout;
- (void)updateSelectionMark;
- (void)doSelect:(id)aController;

- (CRItemsCollectionViewSelectionMarker *)makeSelectionMarker;
- (CRItemViewControllerBase *)makeProxyForObject:(id)object;
- (NSView *)newPlaceholderView;

- (void)cleanItems;
- (void)reloadItems;
- (void)moveItem:(NSUInteger)fromIndex toPosition:(NSUInteger)toIndex;
- (BOOL)downtree:(NSView *)rootView contains:(NSView *)aView;

- (NSDragOperation)getDragOperation:(id<NSDraggingInfo>)sender;

@end